


/**
 ******************************************************************************
 *
 * @file        MG32_Mouse_API.h
 * @brief       Mouse API H file.
 
 * @par         Project
 *              Mouse
 * @version     V1.00
 * @date        2022/03/23
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 * 
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */
 
#ifndef __USBD_MOUSE_H
#define __USBD_MOUSE_H  


#include "MG32.h" 
#include "MG32_EXIC_DRV.h"


/**
 * @name  define
 */
///@{ 


/*Interrupt configure*/
#define MOUSE_BTN_EXIC_IT                EXIC_PC_IT     
#define MOUSE_WHEEL_EXIC_IT              EXIC_PB_IT
                                         
#define MOUSE_BTN_EXIC_MODE_PORT         EXIC_PC                      
#define MOUSE_WHEEL_EXIC_MODE_PORT       EXIC_PB                                        
                                         
#define MOUSE_BTN_L_EXIC_MODE_PIN        EXIC_TRGS_PIN8        
#define MOUSE_BTN_R_EXIC_MODE_PIN        EXIC_TRGS_PIN9  
#define MOUSE_BTN_M_EXIC_MODE_PIN        EXIC_TRGS_PIN10  
#define MOUSE_BTN_BW_EXIC_MODE_PIN       EXIC_TRGS_PIN11 
#define MOUSE_BTN_FW_EXIC_MODE_PIN       EXIC_TRGS_PIN12 

#define MOUSE_WHEEL_ZA_EXIC_MODE_PIN     EXIC_TRGS_PIN0
#define MOUSE_WHEEL_ZB_EXIC_MODE_PIN     EXIC_TRGS_PIN1

#define MOUSE_BTN_L_EXIC_MASK            EXIC_PX_PIN8
#define MOUSE_BTN_R_EXIC_MASK            EXIC_PX_PIN9
#define MOUSE_BTN_M_EXIC_MASK            EXIC_PX_PIN10
#define MOUSE_BTN_BW_EXIC_MASK           EXIC_PX_PIN11
#define MOUSE_BTN_FW_EXIC_MASK           EXIC_PX_PIN12
                          
#define MOUSE_WHEEL_ZA_EXIC_MASK         EXIC_PX_PIN0
#define MOUSE_WHEEL_ZB_EXIC_MASK         EXIC_PX_PIN1

#define MOUSE_BTN_IRQHandler             EXINT2_IRQHandler
#define MOUSE_WHEEL_IRQHandler           EXINT1_IRQHandler


/*USB*/
#define Mouse_EPn                        USB_EP2                    /*!< mouse use endpoint*/
#define Mouse_IT_EPn                     USB_IT_EP2                 /*!< mouse endpoint flag.*/                 

/*Mouse Status*/
#define Mouse_Status_Idle                0x00                       /*!< Mouse state is idle*/
#define Mouse_Status_Init                0x80                       /*!< Mouse state is initializing.*/
#define Mouse_Status_UpdateReport        0x40                       /*!< Mouse update data to host.*/
#define Mouse_Status_BNTReportChange     0x01                       /*!< Mouse button data of report change.*/
#define Mouse_Status_SensorReportChange  0x02                       /*!< Mouse sensor data of report change.*/
#define Mouse_Status_WheelReportChange   0x04                       /*!< Mouse wheel data of report change.*/

#define Mouse_Status_ReportChange        (Mouse_Status_BNTReportChange    | \
                                          Mouse_Status_SensorReportChange | \
                                          Mouse_Status_WheelReportChange)           /*Mouse report data change mask*/


/*Report */
#define Mouse_BIOS_ReportSize           3        /*!< Mouse report size in BIOS*/
#define Mouse_BIOS_Report_Button        0        /*!< Mouse report byte0 is button in BIOS.*/
#define Mouse_BIOS_Report_X             1        /*!< Mouse report byte1 is Sensor_X in BIOS.*/
#define Mouse_BIOS_Report_Y             2        /*!< Mouse report byte2 is Sensor_X in BIOS.*/

#define Mosue_ReportSize                6        /*!< Mouse report size .*/
#define Mouse_Report_Button             0        /*!< Mouse report byte0 is Button.*/
#define Mouse_Report_X_L                1        /*!< Mouse report byte1 is Sensor_X low byte.*/
#define Mouse_Report_X_H                2        /*!< Mouse report byte2 is Sensor_X high byte.*/
#define Mouse_Report_Y_L                3        /*!< Mouse report byte3 is Sensor_Y low byte.*/
#define Mouse_Report_Y_H                4        /*!< Mouse report byte4 is Sensor_Y high byte.*/
#define Mouse_Report_Wheel              5        /*!< Mouse report byte5 is wheel data.*/


///@} 

/**
 * @name  typedef
 */
///@{
 
 
/*! @struct MouseReport_TypeDef
    @brief  Mouse report format
*/  
typedef struct
{
    union 
    {
        uint16_t H;
        uint8_t  B[2];
    }X_Axis;                                   /*!< Sensor X data.*/
    
    union 
    {
        uint16_t H;
        uint8_t  B[2];
    }Y_Axis;                                   /*!< Sensor Y data.*/
     
    union
    {
        uint8_t B;
        struct
        {
            uint8_t L_Button    :1;            /*!< Left     button.*/
            uint8_t R_Button    :1;            /*!< Right    button.*/
            uint8_t M_Button    :1;            /*!< Middle   button.*/
            uint8_t BW_Button   :1;            /*!< Backward button.*/
            uint8_t FW_Button   :1;            /*!< forward  button.*/
            uint8_t             :3;            /*!< reserve.*/
        }MBIT;
    }Button;
    
    int8_t Wheel;                              /*!< Wheel data.*/
    
}MouseReport_TypeDef;    
 
 
/*! @struct MouseCTR_TypeDef
    @brief  Mouse control struct
*/  
typedef struct 
{
    uint8_t             Status;              
    uint8_t             IdleRate;
    uint8_t             Protocol;
    
    uint8_t             BaseCount;
    
    MouseReport_TypeDef ReportDataTmp;                      
    uint8_t             ReportData[Mosue_ReportSize];       
    
}MouseCTR_TypeDef;



///@} 
 

/**
 * @name  variables
 */
///@{
extern MouseCTR_TypeDef Mouse_CTR;

///@}


/**
 * @name  function
 */
///@{
void API_Mouse_Parameter_DeInit(void);
void API_Mouse_Init(void);
void API_Mouse_WakeupIT_Cmd( FunctionalState Mouse_Wakeup_Cmd);
void API_Mouse_ButtonHandler(void);
void API_Mouse_SensorHandler(void);
void API_Mouse_WheelHandler(void);
void API_Mouse_ReportHandler(void);
void API_Mouse_USBHandler(void);
void API_Mouse_Handler(void);


///@}


#endif 







